<?php

/*---------------------------------------------
  MAIAN ADS v1.1
  Written by David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: www.maianads.com
----------------------------------------------*/

// Error reporting..
error_reporting(0);

// Start session..
session_start();

// Define vars..
define('INC_FILES', 1);

// Set paths..
define('PATH', dirname(__FILE__).'/');
define('REL_PATH', '../');

// Load include files..
include(REL_PATH.'inc/functions.php');
include(REL_PATH.'inc/config.php');
include(PATH.'classes/pagination.php');
include(PATH.'classes/feedManager.php');
include(PATH.'classes/graphs.php');

// Load language file..
// Check if file exists..
if (file_exists(REL_PATH.'lang/'.LANGUAGE)) {
  include(REL_PATH.'lang/'.LANGUAGE);
} else {
  die('<span style="color:red;display:block;padding-bottom:10px">ERROR!!</span>
      <b>'.LANGUAGE.'</b>'.$msg_script15
      );
}

// Initiate vars..
$cmd            = (isset($_GET['cmd']) ? $_GET['cmd'] : 'home');
$page           = (isset($_GET['next']) && (int)$_GET['next']>0 ? $_GET['next'] : '1');
$limit          = $page * DATA_PER_PAGE - (DATA_PER_PAGE);
$count          = 0;
$title          = $msg_script.' '.$msg_script2.' - '.$msg_script14.' -'.$msg_header;
$PGM            = getProgramData();
$tabIndex       = 0;

// Create class objects..
$RFM            = new feedManager();
$RFM->prefix    = DB_PREFIX;
$GRAPH          = new graphs();
$GRAPH->prefix  = DB_PREFIX;

// Checks..
if (phpVersion()<5) {
  echo '<p class="sys_error">Your PHP version ('.phpVersion().') is too old. 5.0 or higher required.</p>';
  exit;
}

// Load templates..
switch ($cmd) 
{
  // Home..
  case 'home':
  
  isSessionActive();
  
  $title = $title.' - '.$msg_header2;
  
  include(PATH.'templates/header.php');
  include(PATH.'templates/home.php');
  include(PATH.'templates/footer.php');
  break;
  
  // Ad Management..
  case 'ads':
  
  isSessionActive();
  
  // Open/close form box..
  if (isset($_GET['show'])) {
    if ($_GET['show']=='yes') {
      unset($_SESSION['close_ads']);
    } else {
      $_SESSION['close_ads'] = time();
    }
    header("Location: index.php?cmd=ads");
    exit;
  }
  
  // Enable/disable..
  if (isset($_GET['enable'])) {
    mysql_query("UPDATE ".DB_PREFIX."adverts SET 
                 enabled = '".($_GET['enable']=='no' ? '0' : '1')."'
                 ".(isset($_GET['ad']) ? 'WHERE TableKey = \''.(int)$_GET['ad'].'\'' : '')."
                 ") or die(db_MSG(__FILE__,__LINE__));
    header("Location: index.php?cmd=ads");
    exit;             
  }
  
  // Add new ad..
  if (isset($_POST['add'])) {
    $_POST = array_map('trim',$_POST);
    if ($_POST['title'] && $_POST['keys'] && $_POST['url'] && $_POST['url2']) {
      mysql_query("INSERT INTO ".DB_PREFIX."adverts (
                   KeyWord,
                   Title,
                   URL,
                   DISPLAYURL,
                   isdoubleunderline,
                   addType,
                   n_displays,
                   n_clicks,
                   enabled
                   ) VALUES (
                   '".safeImport(nukeTrailingComma($_POST['keys']))."',
                   '".safeImport($_POST['title'])."',
                   '".safeImport($_POST['url'])."',
                   '".safeImport($_POST['url2'])."',
                   '".(isset($_POST['doubleuline']) ? '1' : '0')."',
                   '".safeImport($_POST['type'])."',
                   '".safeImport($_POST['n_displays'])."',
                   '".safeImport($_POST['n_clicks'])."',
                   '".(isset($_POST['enabled']) ? '1' : '0')."'
                   )") or die(db_MSG(__FILE__,__LINE__));
    } 
    header("Location: index.php?cmd=ads");
    exit;
  }
  
  // Update ad..
  if (isset($_POST['update'])) {
    $_POST = array_map('trim',$_POST);
    if ($_POST['title'] && $_POST['keys'] && $_POST['url'] && $_POST['url2']) {
      mysql_query("UPDATE ".DB_PREFIX."adverts SET
                   KeyWord            = '".safeImport(nukeTrailingComma($_POST['keys']))."',
                   Title              = '".safeImport($_POST['title'])."',
                   URL                = '".safeImport($_POST['url'])."',
                   DISPLAYURL         = '".safeImport($_POST['url2'])."',
                   isdoubleunderline  = '".(isset($_POST['doubleuline']) ? '1' : '0')."',
                   addType            = '".safeImport($_POST['type'])."',
                   n_displays         = '".safeImport($_POST['n_displays'])."',
                   n_clicks           = '".safeImport($_POST['n_clicks'])."',
                   enabled            = '".(isset($_POST['enabled']) ? '1' : '0')."'
                   WHERE TableKey     = '".(int)$_POST['id']."'
                   LIMIT 1
                   ") or die(db_MSG(__FILE__,__LINE__));
    } 
    header("Location: index.php?cmd=ads&edit=".$_POST['id']);
    exit;
  }
  
  // Delete ad..
  if (isset($_GET['delete'])) {
    $_GET['delete'] = (int)$_GET['delete'];
    mysql_query("DELETE FROM ".DB_PREFIX."adverts
                 WHERE TableKey  = '".$_GET['delete']."'
                 LIMIT 1
                 ") or die(db_MSG(__FILE__,__LINE__));
    mysql_query("DELETE FROM ".DB_PREFIX."stats_data WHERE adID = '".$_GET['delete']."'") or die(db_MSG(__FILE__,__LINE__));
    mysql_query("DELETE FROM ".DB_PREFIX."stats_clicks WHERE adID = '".$_GET['delete']."'") or die(db_MSG(__FILE__,__LINE__));
    mysql_query("DELETE FROM ".DB_PREFIX."stats_displays WHERE adID = '".$_GET['delete']."'") or die(db_MSG(__FILE__,__LINE__));
    mysql_query("DELETE FROM ".DB_PREFIX."stats WHERE adID = '".$_GET['delete']."' LIMIT 1") or die(db_MSG(__FILE__,__LINE__));
    header("Location: index.php?cmd=ads");
    exit;             
  }
  
  $title = $title.' - '.$msg_header4;
  
  include(PATH.'templates/header.php');
  include(PATH.'templates/ads.php');
  include(PATH.'templates/footer.php');
  break;
  
  // ClickBank/Paydotcom Data Feed..
  case 'feed-cb':
  case 'feed-pdc':
  
  isSessionActive();
  
  $title = $title.' - '.($cmd=='feed-cb' ? $msg_header5 : $msg_header10);
  
  include(PATH.'templates/header.php');
  include(PATH.'templates/'.$cmd.'.php');
  include(PATH.'templates/footer.php');
  break;
  
  // Manual Feeds..
  case 'feed-manual-cb':
  case 'feed-manual-pdc':
  
  isSessionActive();
  
  $title = $title.' - '.$msg_feed13;
  
  include(PATH.'templates/header.php');
  include(PATH.'templates/'.$cmd.'.php');
  include(PATH.'templates/footer.php');
  break;
  
  // Promote Clickbank..
  case 'promote':
  
  isSessionActive();
  
  if (isset($_GET['help'])) {
    include(PATH.'templates/search-help.php');
    exit;
  }
  
  // Create new ad..
  if (isset($_GET['create']) || isset($_POST['create'])) {
    // Create ad..
    if (isset($_POST['create'])) {
      if ($_POST['title'] && $_POST['keys'] && $_POST['url'] && $_POST['url2']) {
        mysql_query("INSERT INTO ".DB_PREFIX."adverts (
                     KeyWord,
                     Title,
                     URL,
                     DISPLAYURL,
                     isdoubleunderline,
                     addType,
                     enabled
                     ) VALUES (
                     '".safeImport(nukeTrailingComma($_POST['keys']))."',
                     '".safeImport($_POST['title'])."',
                     '".safeImport($_POST['url'])."',
                     '".safeImport($_POST['url2'])."',
                     '".(isset($_POST['doubleuline']) ? '1' : '0')."',
                     '".safeImport($_POST['cat'])."',
                     '".(isset($_POST['enabled']) ? '1' : '0')."'
                     )") or die(db_MSG(__FILE__,__LINE__));
        $CREATED = true;             
      } 
    }
    include(PATH.'templates/create_new_ad.php');
    exit;
  }
  
  $OB   = '';
  $SQL  = '';
  
  // Search..
  if (isset($_GET['search'])) {
    $_GET = array_map('trim',$_GET);
    if (get_magic_quotes_gpc()) {
      $_GET = array_map('stripslashes',$_GET);
    }
    if (function_exists('htmlspecialchars_decode')) {
      $_GET = array_map('htmlspecialchars_decode',$_GET);
    } else {
      $_GET['keys'] = str_replace('&quot;','"',$_GET['keys']);
    }
    if ($_GET['keys']!='') {
      // Category..
      if ($_GET['cat']!='all_cats') {
        $SQL = "AND category = '".safeImport($_GET['cat'])."'";
      }
      // Product Type..
      if ($_GET['type']!='all') {
        $SQL .= "AND isRecurring = '".($_GET['type']=='recurring' ? 1 : 0)."'"; 
      }
      // Order by..
      switch ($_GET['order']) {
        case 'pop':        $OB = 'ORDER BY PopularityRank';      break;  
        case 'grav_desc':  $OB = 'ORDER BY Gravity DESC';        break; 
        case 'grav_asc':   $OB = 'ORDER BY Gravity';             break; 
        case 'sale_desc':  $OB = 'ORDER BY EarnedPerSale DESC';  break; 
        case 'sale_asc':   $OB = 'ORDER BY EarnedPerSale';       break; 
        case 'perc_desc':  $OB = 'ORDER BY PercentPerSale DESC'; break; 
        case 'perc_asc':   $OB = 'ORDER BY PercentPerSale';      break; 
        case 'title_asc':  $OB = 'ORDER BY Title';               break; 
        case 'title_desc': $OB = 'ORDER BY Title DESC';          break; 
      }
      // Query..
      $q_search = mysql_query("SELECT SQL_CALC_FOUND_ROWS * FROM ".DB_PREFIX."clickbankmarketplace
                               WHERE (Title LIKE '%".safeImport($_GET['keys'])."%' OR Description LIKE '%".safeImport($_GET['keys'])."%')
                               $SQL
                               $OB
                               LIMIT $limit,".(isset($_GET['show']) ? (int)$_GET['show'] : DATA_PER_PAGE)."
                               ") or die(db_MSG(__FILE__,__LINE__));
      if (mysql_num_rows($q_search)==0) {
        $NONE = true;
      } else {
        $c            = mysql_fetch_object(mysql_query("SELECT FOUND_ROWS() AS rows"));
        $countedRows  =  (isset($c->rows) ? $c->rows : '0');
        $RESULTS = true;
      }
      $SEARCH = true;
    }
  }
  
  $title    = $title.' - '.$msg_header6;
  $colorBox = true;
  
  include(PATH.'templates/header.php');
  include(PATH.'templates/promote.php');
  include(PATH.'templates/footer.php');
  break;
  
 // Promote PayDotCom..
  case 'promote2':
  
  isSessionActive();
  
  $OB   = '';
  $SQL  = '';
  
  // Search..
  if (isset($_GET['search'])) {
    $_GET = array_map('trim',$_GET);
    if (get_magic_quotes_gpc()) {
      $_GET = array_map('stripslashes',$_GET);
    }
    if (function_exists('htmlspecialchars_decode')) {
      $_GET = array_map('htmlspecialchars_decode',$_GET);
    } else {
      $_GET['keys'] = str_replace('&quot;','"',$_GET['keys']);
    }
    if ($_GET['keys']!='') {
      // Category..
      if ($_GET['cat']!='all_cats') {
        $SQL = "AND main_category1 = '".safeImport($_GET['cat'])."'";
      }
      // Sub Category..
      if ($_GET['sub']!='all_cats') {
        $SQL = "AND category1 = '".safeImport($_GET['cat'])."'";
      }
      // Order by..
      switch ($_GET['order']) {
        case 'newest':     $OB = 'ORDER BY date_added DESC'; break;  
        case 'oldest':     $OB = 'ORDER BY date_added';      break; 
        case 'price_desc': $OB = 'ORDER BY price DESC';      break; 
        case 'price_asc':  $OB = 'ORDER BY price';           break; 
        case 'max':        $OB = 'ORDER BY totalSale DESC';  break;
      }
      // Query..
      $q_search = mysql_query("SELECT SQL_CALC_FOUND_ROWS *,DATE_FORMAT(date_added,'%e %M %Y') AS a_date 
                               FROM ".DB_PREFIX."pdcmarketplace
                               WHERE (name LIKE '%".safeImport($_GET['keys'])."%' OR description LIKE '%".safeImport($_GET['keys'])."%')
                               $SQL
                               $OB
                               LIMIT $limit,".(isset($_GET['show']) ? (int)$_GET['show'] : DATA_PER_PAGE)."
                               ") or die(db_MSG(__FILE__,__LINE__));
      if (mysql_num_rows($q_search)==0) {
        $NONE = true;
      } else {
        $c            = mysql_fetch_object(mysql_query("SELECT FOUND_ROWS() AS rows"));
        $countedRows  =  (isset($c->rows) ? $c->rows : '0');
        $RESULTS      = true;
      }
      $SEARCH = true;
    }
  }
  
  $title    = $title.' - '.$msg_header11;
  $colorBox = true;
  
  include(PATH.'templates/header.php');
  include(PATH.'templates/promote2.php');
  include(PATH.'templates/footer.php');
  break;
  
  // Javascript Code..
  case 'code':
  
  isSessionActive();
  
  $title = $title.' - '.$msg_header7;
  
  include(PATH.'templates/header.php');
  include(PATH.'templates/code.php');
  include(PATH.'templates/footer.php');
  break;
  
  // Stats..
  case 'stats':
  
  isSessionActive();
  
  if (isset($_GET['ref'])) {
    $title = $title.' - '.$msg_header8;
    include(PATH.'templates/stats/referrer.php');
    exit;
  }
  
  if (isset($_GET['graph'])) {
    switch ($_GET['graph']) {
      case 'last7days': 
      $GRAPH->series   = $GRAPH->getCalendarDates((isset($_GET['days']) ? (int)$_GET['days'] : '7'));
      $GRAPH->gid      = $GRAPH->dbQueryString($_GET['graph'],(isset($_GET['days']) ? (int)$_GET['days'] : '7'),(isset($_GET['ad']) ? 'AND adID=\''.(int)$_GET['ad'].'\'' : '').(isset($_GET['filter']) && in_array($_GET['filter'],array('ALL','CB','PDC','OTHER'))? 'AND addType=\''.$_GET['filter'].'\'' : ''));
      $GRAPH->title    = array($msg_stats50,$msg_stats51);
      $GRAPH->gCount   = 2;
      echo $GRAPH->buildGraph();
      break;
      case 'lastmonth': 
      $GRAPH->series   = $GRAPH->getCalendarMonths((isset($_GET['months']) ? $_GET['months'] : '6'));
      $GRAPH->gid      = $GRAPH->dbQueryString($_GET['graph'],(isset($_GET['months']) ? (int)$_GET['months'] : '6'),(isset($_GET['ad']) ? 'AND adID=\''.(int)$_GET['ad'].'\'' : '').(isset($_GET['filter']) && in_array($_GET['filter'],array('ALL','CB','PDC','OTHER'))? 'AND addType=\''.$_GET['filter'].'\'' : ''));
      $GRAPH->title    = array($msg_stats50,$msg_stats51);
      $GRAPH->gCount   = 2;
      echo $GRAPH->buildGraph();
      break;
      case 'keywords':
      $condition       = (isset($_GET['ad']) ? 'WHERE adID=\''.(int)$_GET['ad'].'\'' : '').(isset($_GET['filter']) && in_array($_GET['filter'],array('ALL','CB','PDC','OTHER')) ? (isset($_GET['ad']) ? ' AND' : 'WHERE').' addType=\''.$_GET['filter'].'\'' : '');
      $GRAPH->text     = $msg_stats40;
      $GRAPH->adverts  = $GRAPH->getKeywords(10,$condition,'title');
      $GRAPH->series   = $GRAPH->getKeywords(10,$condition);
      $GRAPH->gid      = $GRAPH->dbQueryString($_GET['graph'],10,$condition);
      $GRAPH->title    = array('','');
      $GRAPH->gCount   = 2;
      echo $GRAPH->buildGraph();
      break;
    }
    exit;
  }
  
  // Download CSV..
  if (isset($_POST['csv'])) {
    // Build query.. 
    $sql = '';
    if (in_array($_POST['filter'],array('CB','PDC','OTHER'))) {
      $sql = "WHERE addType = '".$_POST['filter']."'";
    } 
    if ($_POST['from'] && $_POST['to']) {
      $sql .= ($sql ? ' AND addDate BETWEEN \''.substr($_POST['from'],0,10).'\' AND \''.substr($_POST['to'],0,10).'\'' : 'WHERE addDate BETWEEN \''.substr($_POST['from'],0,10).'\' AND \''.substr($_POST['to'],0,10).'\'');
    }
    // Start CSV..
    if (isset($_POST['ref']) && isset($_POST['agent'])) {
      $csv = $msg_script32.define_newline();
    } elseif (!isset($_POST['ref']) && isset($_POST['agent'])) {
      $csv = $msg_script31.define_newline();
    } elseif (isset($_POST['ref']) && !isset($_POST['agent'])) {
      $csv = $msg_script30.define_newline();
    } else {
      $csv = $msg_script12.define_newline();
    }
    // Get data..
    $q_stats = mysql_query("SELECT * FROM ".DB_PREFIX."stats
                            ".(isset($sql) ? $sql : '')."
                            ORDER BY KeyWord
                            ") or die(db_MSG(__FILE__,__LINE__));
    while ($STATS = mysql_fetch_object($q_stats)) {
      $AD   = getAd($STATS->adID);
      $csv .= csvCleanUp($STATS->KeyWord).",".csvCleanUp($AD->Title).",".rowCount('stats_displays',' WHERE asStat = \''.$STATS->id.'\'').",".rowCount('stats_clicks',' WHERE asStat = \''.$STATS->id.'\'').",".(isset($_POST['ref']) ? getReferers($STATS->id).',' : '').(isset($_POST['agent']) ? getAgents($STATS->id).',' : '').getAddType($STATS->addType).define_newline();
    }            
    // Download..     
    if (is_writeable(PATH.'marketplace')) {
      $filename  = PATH.'marketplace/statistics-'.date("d-m-Y").'.csv';
      $fp        = fopen($filename, 'ab');
      if ($fp) {
        fwrite($fp,trim($csv));
        fclose($fp);
      }
      unset($csv);

      if(ini_get('zlib.output_compression')) {
        ini_set('zlib.output_compression', 'Off');
      }
                                           
      header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
      header('Pragma: public');
		    header('Expires: 0');
		    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		    header('Cache-Control: private',false);
		    header('Content-Type: application/force-download');
		    header('Content-Type: application/csv');
		    header('Content-Disposition: attachment; filename='.basename($filename).';');
		    header('Content-Transfer-Encoding: binary');
		    header('Content-Length: '.filesize($filename));
		    @ob_end_flush();           
      readfile($filename);
      // Delete temp file..
      if (file_exists($filename)) {
        unlink($filename);
      }
      exit;
    }
  }
  
  // Clear stats..
  if (isset($_POST['clear'])) {
    // Build query.. 
    if (in_array($_POST['filter'],array('CB','PDC','OTHER'))) {
      $sql = "WHERE addType = '".$_POST['filter']."'";
    } 
    if ($_POST['from'] && $_POST['to']) {
      $sql .= ($sql ? ' AND addDate BETWEEN \''.substr($_POST['from'],0,10).'\' AND \''.substr($_POST['to'],0,10).'\'' : 'WHERE addDate BETWEEN \''.substr($_POST['from'],0,10).'\' AND \''.substr($_POST['to'],0,10).'\'');
    }
    $query = mysql_query("SELECT * FROM ".DB_PREFIX."stats 
                         ".(isset($sql) ? $sql : '')."
                         ") or die(db_MSG(__FILE__,__LINE__));
    if (mysql_num_rows($query)>0) {
      while ($STATS = mysql_fetch_object($query)) {
        mysql_query("DELETE FROM ".DB_PREFIX."stats_data WHERE adID = '".$STATS->adID."'") or die(db_MSG(__FILE__,__LINE__));
        mysql_query("DELETE FROM ".DB_PREFIX."stats_clicks WHERE adID = '".$STATS->adID."'") or die(db_MSG(__FILE__,__LINE__));
        mysql_query("DELETE FROM ".DB_PREFIX."stats_displays WHERE adID = '".$STATS->adID."'") or die(db_MSG(__FILE__,__LINE__));
        mysql_query("DELETE FROM ".DB_PREFIX."stats WHERE adID = '".$STATS->adID."' LIMIT 1") or die(db_MSG(__FILE__,__LINE__));
      }
    }
  }
  
  // Clear ad stats..
  if (isset($_GET['clear']) && isset($_GET['t'])) {
    mysql_query("DELETE FROM ".DB_PREFIX."stats_data WHERE adID = '".$_GET['ad']."'") or die(db_MSG(__FILE__,__LINE__));
    mysql_query("DELETE FROM ".DB_PREFIX."stats_clicks WHERE adID = '".$_GET['ad']."'") or die(db_MSG(__FILE__,__LINE__));
    mysql_query("DELETE FROM ".DB_PREFIX."stats_displays WHERE adID = '".$_GET['ad']."'") or die(db_MSG(__FILE__,__LINE__));
    mysql_query("DELETE FROM ".DB_PREFIX."stats WHERE adID = '".$_GET['ad']."' LIMIT 1") or die(db_MSG(__FILE__,__LINE__));
    header("Location: index.php?cmd=stats&t=ad&ad=".$_GET['ad']);
    exit;
  }
  
  // Set order by option..
  if (isset($_GET['order'])) {
    switch ($_GET['order']) {
      case 'display_desc': $ORDER = 'ORDER BY numberdisplays DESC';   break;  
      case 'display_asc':  $ORDER = 'ORDER BY numberdisplays';        break; 
      case 'clicks_desc':  $ORDER = 'ORDER BY numberclicks DESC';     break; 
      case 'clicks_asc':   $ORDER = 'ORDER BY numberclicks';          break; 
      case 'referer_asc':  $ORDER = 'ORDER BY referrer,KeyWord';      break; 
      case 'referer_desc': $ORDER = 'ORDER BY referrer DESC,KeyWord'; break; 
      case 'keys_desc':    $ORDER = 'ORDER BY KeyWord DESC';          break; 
      case 'keys_asc':     $ORDER = 'ORDER BY KeyWord';               break; 
    }
  }
  
  // Set filter by option..
  if (isset($_GET['filter'])) {
    switch ($_GET['filter']) {
      case 'ALL': '';   break;  
      case 'CB':    $FILTER = "WHERE addType = 'CB'";    break; 
      case 'PDC':   $FILTER = "WHERE addType = 'PDC'";   break; 
      case 'OTHER': $FILTER = "WHERE addType = 'OTHER'"; break; 
    }
  }
  
  $title = $title.' - '.$msg_header8;
  $colorBox = true;
  
  include(PATH.'templates/header.php');
  include(PATH.'templates/stats/'.(isset($_GET['t']) && in_array($_GET['t'],array('keyword','ad','clear','csv')) ? $_GET['t'] : 'stats').'.php');
  include(PATH.'templates/footer.php');
  break;
  
  case 'auto-cb':
  case 'auto-pdc':
  
  isSessionActive();
  
  // 2 second pause enables div to load..
  sleep(2);
  // Set timeout in case feeds are big..
  @ini_set('memory_limit', '150M');
  @set_time_limit(0);
  
  if ($cmd=='auto-cb') {
    $feed = PATH.'marketplace/marketplace_feed_v1.xml';
    // If feed doesn`t exist, try getting it from Clickbank..
    if (!file_exists(PATH.'marketplace/marketplace_feed_v1.xml')) {
	     $ret = $RFM->getfile(CLICKBANK_FEED);
	     if ($ret=='ERR-FEED') {
	       echo 'ERR-FEED#####'.$msg_feed17;
	       exit;
	     }
	     if ($ret=='ERR-UNZIP') {
	       echo 'ERR-UNZIP#####'.$msg_feed18;
	       exit;
	     }
	   }
	   // Parse feed..
	   $XML_CNT = $RFM->import(PATH.'marketplace/marketplace_feed_v1.xml','cb');
	   echo 'OK#####'.str_replace('{count}',@number_format($XML_CNT),$msg_feed20);
	   exit;
	 } else {
	   $feed = PATH.'marketplace/marketplace.xml';
		  if (!file_exists(PATH.'marketplace/marketplace.xml')) {
	     $ret = $RFM->getfile(PAYDOTCOM_FEED);
	     if ($ret=='ERR-FEED') {
	       echo 'ERR-FEED#####'.$msg_feed17;
	       exit;
	     }
	     if ($ret=='ERR-UNZIP') {
	       echo 'ERR-UNZIP#####'.$msg_feed18;
	       exit;
	     }
	   } 
	   $XML_CNT = $RFM->import(PATH.'marketplace/marketplace.xml','pdc');
	   echo 'OK#####'.str_replace('{count}',@number_format($XML_CNT),$msg_feed19);
	   exit;
		}
	 echo 'ERR#####'.$msg_feed21;
		break;
  
  // Login..
  case 'login':
  
  if (isset($_SESSION[encrypt(SECRET_KEY)])) {
    header("Location: index.php");
    exit;
  }
  
  // Process..
  if (isset($_POST['process'])) {
    $_POST = array_map('trim',$_POST);
    if ($_POST['user'] && $_POST['pass']) {
      if ($_POST['user']!=USERNAME) {
        $U_ERROR = true;
        $count++;
      }
      if (encrypt($_POST['pass']).encrypt(SECRET_KEY)!=encrypt(PASSWORD).encrypt(SECRET_KEY)) {
        $P_ERROR = true;
        $count++;
      }
      if ($count==0) {
        // Set session var..
        $key = encrypt(SECRET_KEY);
        $_SESSION[$key] = md5(time());
        header("Location: index.php");
        exit;
      }
    } else {
      header("Location: index.php?cmd=login");
      exit;
    }
  }
  
  $title = $title.' - '.$msg_header9;
  
  include(PATH.'templates/login.php');
  break;
  
  // Logout..
  case 'logout':
  
  // Kill session..
  session_unset();
  session_destroy();
  unset($_SESSION);
  
  header("Location: index.php?cmd=login");
  break;
}

?>
